// Add this to your qrcode-wrapper.js file
window.generateQRCode = function(text, elementId, size = 200) {
    try {
        console.log('Generating QR code for:', elementId, 'with text:', text.substring(0, 10) + '...');

        // Clear any existing content
        const element = document.getElementById(elementId);
        if (!element) {
            console.error('QR code element not found:', elementId);
            return false;
        }
        element.innerHTML = '';

        // Check if the QRCode constructor exists
        if (typeof QRCode === 'function') {
            // Create QR code directly in the target element
            try {
                new QRCode(element, {
                    text: text,
                    width: size,
                    height: size,
                    colorDark: "#000000",
                    colorLight: "#ffffff",
                    correctLevel: QRCode.CorrectLevel.H
                });
                console.log('QR code created successfully for', elementId);
                return true;
            } catch (e) {
                console.error('Error creating QR code object:', e);
                // Continue to fallback
            }
        } else {
            console.error('QRCode constructor not available, using fallback display');
        }

        // Fallback: Just show text or a basic representation
        const fallbackContainer = document.createElement('div');
        fallbackContainer.className = 'qr-fallback';
        fallbackContainer.style.width = size + 'px';
        fallbackContainer.style.height = size + 'px';
        fallbackContainer.style.border = '1px solid #000';
        fallbackContainer.style.display = 'flex';
        fallbackContainer.style.alignItems = 'center';
        fallbackContainer.style.justifyContent = 'center';

        // Add a simplified visual representation
        const patternContainer = document.createElement('div');
        patternContainer.style.width = '80%';
        patternContainer.style.height = '80%';
        patternContainer.style.display = 'grid';
        patternContainer.style.gridTemplateColumns = 'repeat(5, 1fr)';
        patternContainer.style.gridTemplateRows = 'repeat(5, 1fr)';
        patternContainer.style.gap = '2px';

        // Create a simple pattern based on the text
        for (let i = 0; i < 25; i++) {
            const cell = document.createElement('div');
            const charCode = text.charCodeAt(i % text.length);
            cell.style.backgroundColor = charCode % 2 === 0 ? '#000' : '#fff';
            patternContainer.appendChild(cell);
        }

        fallbackContainer.appendChild(patternContainer);

        // Add small text below
        const textDisplay = document.createElement('div');
        textDisplay.style.fontSize = '8px';
        textDisplay.style.wordBreak = 'break-all';
        textDisplay.style.position = 'absolute';
        textDisplay.style.bottom = '0';
        textDisplay.style.width = '100%';
        textDisplay.style.textAlign = 'center';

        // Show just first and last few characters
        const firstChars = text.substring(0, 5);
        const lastChars = text.substring(text.length - 5);
        textDisplay.textContent = firstChars + '...' + lastChars;

        fallbackContainer.appendChild(textDisplay);
        element.appendChild(fallbackContainer);

        // Add a title with the full text for hover
        element.title = text;

        console.log('QR fallback displayed for', elementId);
        return false;
    } catch (e) {
        console.error('Error in generateQRCode function:', e);
        return false;
    }
};