   document.addEventListener('DOMContentLoaded', function() {
       // --- BIP38 Tooltip ---
       const bip38Trigger = document.getElementById('bip38-info-trigger');
       const bip38Tooltip = document.getElementById('bip38-tooltip');

       if (bip38Trigger && bip38Tooltip) {
           bip38Trigger.addEventListener('click', function(event) {
               // Prevent the click from propagating if it's inside another clickable element (like a label)
               event.stopPropagation();

               // Check current display state
               const isHidden = bip38Tooltip.style.display === 'none' || bip38Tooltip.style.display === '';

               // Toggle display
               if (isHidden) {
                   bip38Tooltip.style.display = 'inline-block'; // Use the display type set in CSS
               } else {
                   bip38Tooltip.style.display = 'none';
               }
           });

           // Hide tooltip if clicking anywhere else on the page
           
           document.addEventListener('click', function(event) {
               // If the tooltip is visible and the click was outside the trigger and tooltip
               if (bip38Tooltip.style.display !== 'none' && event.target !== bip38Trigger && !bip38Tooltip.contains(event.target)) {
                   bip38Tooltip.style.display = 'none';
               }
           });

       } else {
           console.warn("BIP38 tooltip trigger or content element not found. Check IDs.");
       }

       // You could add more tooltip logic here if needed in the future

   }); // End DOMContentLoaded
   